import tkinter

"""
based on code from Nick Parlante for Stanford CS106A
"""


def draw_grid_canvas(grid, canvas, scale):
    """
    Draw the movie grid to the canvas.
    """
    canvas.delete('all')
    canvas.create_rectangle(0, 0, grid.width * scale, grid.height * scale, fill='black')

    for y in range(grid.height):
        for x in range(grid.width):
            val = grid.get(x, y)
            if val:
                pixel_x = scale * x
                pixel_y = scale * y
                canvas.create_text(pixel_x, pixel_y, text=val, anchor=tkinter.NW, fill='white', font=('Courier', 24))

    canvas.update()


# TK Timer fns:


def start_timer(top, delay_ms, fn):
    """Start the my_timer system, calls given fn"""
    top.after(delay_ms, lambda: my_timer(top, delay_ms, fn))


def my_timer(top, delay_ms, fn):
    """my_timer callback, re-posts itself."""
    fn()
    top.after(delay_ms, lambda: my_timer(top, delay_ms, fn))
