def empty_grid(num_rows, num_columns, value=None):
    """
    Create an empty grid. <num_rows> is the number
    of rows in the grid. <num_columns> is the number
    of columns in the grid. Fill the grid with None or with
    whatever value the caller supplies in <value>.
    """
    # create an empty grid
    new_grid = []
    # keep going until we have created all the rows
    while len(new_grid) < num_rows:
        new_row = []
        # keep going until we have all the columns we need
        while len(new_row) < num_columns:
            # append an item for this column
            new_row.append(value)
        # now that we have a full row, append the row
        new_grid.append(new_row)
    return new_grid


def has_value(grid, row, col, value):
    """
    Return true if grid[row][col] == value
    """
    # be sure the row is in the grid
    # if it is not, return False
    if row < 0 or row >= len(grid):
        return False

    # be sure the column is in the grid
    # if it is not, return False
    if col < 0 or col >= len(grid[row]):
        return False

    # return  True ifthe value at (row, column) is equal to value
    return grid[row][col] == value


def create_grid():
    # create an empty grid
    grid = empty_grid(3, 5, value='.')

    # fill in a few places in the grid
    # with some special characters
    grid[0][4] = '*'
    grid[1][2] = '?'
    grid[2][1] = '!'

    return grid


def main():
    grid = create_grid()
    print(has_value(grid, 0, 0, '*'))
    print(has_value(grid, -1, 0, '*'))
    print(has_value(grid, 1, 2, '?'))


if __name__ == '__main__':
    main()
